%This is to test how many steps fits the Simple-Minimum-Difference Strategy
%imple-Minimum-Difference Strategy: Subject moves to the square which the absolute difference between that square and current square is the
%minimum. Only two directions, up and right, is considered. Once a square is visited,
%it will never be visited again. The last step is bounded fitting.

clear;
clc;

tic
addpath('estimation results');
SimpleMinDiffStrategy=zeros(12,16); % Recording analysis results for Simple-Minimum-Difference Strategy

% Treatment 1
clear file
file=dir('data from experiment\T1\*.txt');
for n=1:length(file)
    clear M S % M denotes the map, S denotes the steps
    filename=['data from experiment\T1\',file(n).name];
    if n<=length(file)/4 % Journey 1
        load S1.txt
        M=dlmread('S1.txt');
    elseif n>length(file)/4 && n<=length(file)/2 % Journey 2
        load S2.txt
        M=dlmread('S2.txt');
    elseif n>length(file)/2 && n<=length(file)*(3/4) % Journey 3
        load S3.txt
        M=dlmread('S3.txt');
    else % Journey 4
        load S4.txt
        M=dlmread('S4.txt');
    end
    
    clear S N
    S=dlmread(filename,',');
    N=zeros(size(S(1:end-1,1)));
    for i=1:1:size(S(:,1))-1
        clear a b c f k
        a=M(S(i,1),S(i,2)); %current square
        b=M(S(i,1)-1,S(i,2)); % UP
        c=M(S(i,1),S(i,2)+1); %RIGHT
        f=M(S((i+1),1),S((i+1),2));
            k(1)=abs(a-b);
            k(2)=abs(a-c);
        if abs(a-f)==min(min(k))
            N(i,1)=1;
        end
    end
    
    N(end,1)=1; %Bounded the last step is fitting.
    if mod(n,length(file)/4)==0
        SimpleMinDiffStrategy(length(file)/4,n/(length(file)/4))=sum(N(:,1))/length(N(:,1));
    else
        SimpleMinDiffStrategy(mod(n,length(file)/4),fix(n/(length(file)/4))+1)=sum(N(:,1))/length(N(:,1));
    end
    
end
% End of Treatment 1

% Treatment 2
clear file
file=dir('data from experiment\T2\*.txt');
for n=1:length(file)
    clear M S % M denotes the map, S denotes the steps
    filename=['data from experiment\T2\',file(n).name];
    if n<=length(file)/4 % Journey 1
        load S1.txt
        M=dlmread('S1.txt');
    elseif n>length(file)/4 && n<=length(file)/2 % Journey 2
        load S2.txt
        M=dlmread('S2.txt');
    elseif n>length(file)/2 && n<=length(file)*(3/4) % Journey 3
        load S3.txt
        M=dlmread('S3.txt');
    else % Journey 4
        load S4.txt
        M=dlmread('S4.txt');
    end
    
    clear S N
    S=dlmread(filename,',');
    N=zeros(size(S(1:end-1,1)));
    for i=1:1:size(S(:,1))-1
        clear a b c f k
        a=M(S(i,1),S(i,2)); %current square
        b=M(S(i,1)-1,S(i,2)); % UP
        c=M(S(i,1),S(i,2)+1); %RIGHT
        f=M(S((i+1),1),S((i+1),2));
            k(1)=abs(a-b);
            k(2)=abs(a-c);
        if abs(a-f)==min(min(k))
            N(i,1)=1;
        end
    end
    
    N(end,1)=1; %Bounded the last step is fitting.
    if mod(n,length(file)/4)==0
        SimpleMinDiffStrategy(length(file)/4,n/(length(file)/4)+4)=sum(N(:,1))/length(N(:,1));
    else
        SimpleMinDiffStrategy(mod(n,length(file)/4),fix(n/(length(file)/4))+1+4)=sum(N(:,1))/length(N(:,1));
    end
    
end
% End of Treatment 2

% Treatment 3
clear file
file=dir('data from experiment\T3\*.txt');
for n=1:length(file)
    clear M S % M denotes the map, S denotes the steps
    filename=['data from experiment\T3\',file(n).name];
    if n<=length(file)/4 % Journey 1
        load S1.txt
        M=dlmread('S1.txt');
    elseif n>length(file)/4 && n<=length(file)/2 % Journey 2
        load S2.txt
        M=dlmread('S2.txt');
    elseif n>length(file)/2 && n<=length(file)*(3/4) % Journey 3
        load S3.txt
        M=dlmread('S3.txt');
    else % Journey 4
        load S4.txt
        M=dlmread('S4.txt');
    end
    
    clear S N
    S=dlmread(filename,',');
    N=zeros(size(S(1:end-1,1)));
    for i=1:1:size(S(:,1))-1
        clear a b c f k
        a=M(S(i,1),S(i,2)); %current square
        b=M(S(i,1)-1,S(i,2)); % UP
        c=M(S(i,1),S(i,2)+1); %RIGHT
        f=M(S((i+1),1),S((i+1),2));
            k(1)=abs(a-b);
            k(2)=abs(a-c);
        if abs(a-f)==min(min(k))
            N(i,1)=1;
        end
    end
    
    N(end,1)=1; %Bounded the last step is fitting.
    if mod(n,length(file)/4)==0
        SimpleMinDiffStrategy(length(file)/4,n/(length(file)/4)+8)=sum(N(:,1))/length(N(:,1));
    else
        SimpleMinDiffStrategy(mod(n,length(file)/4),fix(n/(length(file)/4))+1+8)=sum(N(:,1))/length(N(:,1));
    end
    
end
% End of Treatment 3

% Treatment 4
clear file
file=dir('data from experiment\T4\*.txt');
for n=1:length(file)
    clear M S % M denotes the map, S denotes the steps
    filename=['data from experiment\T4\',file(n).name];
    if n<=length(file)/4 % Journey 1
        load S1.txt
        M=dlmread('S1.txt');
    elseif n>length(file)/4 && n<=length(file)/2 % Journey 2
        load S2.txt
        M=dlmread('S2.txt');
    elseif n>length(file)/2 && n<=length(file)*(3/4) % Journey 3
        load S3.txt
        M=dlmread('S3.txt');
    else % Journey 4
        load S4.txt
        M=dlmread('S4.txt');
    end
    
    clear S N
    S=dlmread(filename,',');
    N=zeros(size(S(1:end-1,1)));
    for i=1:1:size(S(:,1))-1
        clear a b c f k
        a=M(S(i,1),S(i,2)); %current square
        b=M(S(i,1)-1,S(i,2)); % UP
        c=M(S(i,1),S(i,2)+1); %RIGHT
        f=M(S((i+1),1),S((i+1),2));
            k(1)=abs(a-b);
            k(2)=abs(a-c);
        if abs(a-f)==min(min(k))
            N(i,1)=1;
        end
    end
    
    N(end,1)=1; %Bounded the last step is fitting.
    if mod(n,length(file)/4)==0
        SimpleMinDiffStrategy(length(file)/4,n/(length(file)/4)+12)=sum(N(:,1))/length(N(:,1));
    else
        SimpleMinDiffStrategy(mod(n,length(file)/4),fix(n/(length(file)/4))+1+12)=sum(N(:,1))/length(N(:,1));
    end
    
end
% End of Treatment 4

resultspath=[pwd,'\estimation results\'];
csvwrite([resultspath,'SimpleMinDiffStrategy.csv'],SimpleMinDiffStrategy);
toc

disp('Finished');